<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\Option;
use App\Models\Question;
use Illuminate\Http\Request;
use App\Http\Controllers\ExamController;
use App\Http\Requests\StoreQuestionRequest;
use App\Http\Requests\UpdateQuestionRequest;

class QuestionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($examId)
    {
       
         $questions = Question::with('exam','options')->where('exam_id',$examId)->get();
        return view('questions.list')->with('questions',$questions);

    }

    

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreQuestionRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreQuestionRequest $request)
    {
     
        $examController = new ExamController;
        try{
        if(!$examController->saveQuestion($request->examId,
            $request->quation,
            $request->aneswerSelect,
            $request->typeQuation,
            $request->mark,
            $request->option))
            return back()->with(['error' => 'لم يتم إضافة الأسئلة  ']);
            
            return back()->with(['success' => 'تم   إضافة الأسئلة بنجاح']);
        } catch (\Throwable $th) {
            return back()->with(['error' => 'لم يتم إضافة الأسئلة  ']);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Question  $question
     * @return \Illuminate\Http\Response
     */
    public function show(Question $question)
    {
        //
    }

   

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateQuestionRequest  $request
     * @param  \App\Models\Question  $question
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateQuestionRequest $request, Question $question)
    {
        if(!isset($request->aneswerSelect))
        return back()->with(['error' => ' يرجى تحديد الإجابه الصحيحة']);
        $updateQuestion = Question::find($request->id);
        $updateQuestion->question_txt = $request->quation;
        $updateQuestion->mark = $request->mark;
        $updateQuestion->update();
        $examController = new ExamController;
       $this->deleteOptions($request->id); 
        try{
        if(!$examController->saveOption($request->id,
            $request->option[0],
            $request->aneswerSelect[0]))
            return back()->with(['error' => 'لم يتم التعديل على السؤال  ']);     
            return back()->with(['success' => 'تم التعديل على السؤال بنجاح']);
        } catch (\Throwable $th) {
            return back()->with(['error' => 'لم يتم إضافة الأسئلة  ']);
        }
    }

    /**
     * [Description for deleteOptions]
     *
     * @param mixed $questionId
     * 
     * @return [type]
     * 
     */
    public function deleteOptions($questionId)
    {
         $options = Option::where('question_id',$questionId)->get();
        foreach ($options as $option) {
            Option::find($option->id)->delete();
        }
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Question  $question
     * @return \Illuminate\Http\Response
     */
    public function destroy(Question $question,Request $request)
    {
        try {
            Question::find($request->id)->delete();
            return back()->with(['success' => 'تم حذف السؤال بنجاح']);
        } catch (\Throwable$th) {
            return back()->with(['error' => 'لم يتم حذف السؤال ']);
        }
    }
}
